window.onload = function() {
    var map = L.map('map').setView([12.3711, -1.5197], 13);
    var destinationMarker; // Marqueur pour la destination
    var sourceMarker; // Marqueur pour le point de départ

    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '© OpenStreetMap contributors',
        minZoom: 1,
        maxZoom: 20
    }).addTo(map);

    var control = L.Routing.control({
        lineOptions: {
            styles: [{ color: '#839c49', opacity: 1, weight: 7 }]
        },
        router: new L.Routing.osrmv1({
            language: 'fr',
            profile: 'car'
        }),
        waypoints: [],
        createMarker: function(i, waypoint, n) {
            var marker = L.marker(waypoint.latLng, { draggable: true })
                .bindPopup(i === 0 ? "Point de départ" : "Point d'arrivée")
                .on('dragend', function(e) {
                    var newLatLng = e.target.getLatLng();
                    control.spliceWaypoints(i, 1, newLatLng);
                    updateMarkers(); // Met à jour les marqueurs sur la carte
                });
            return marker;
        },
        routeWhileDragging: true,
        show: false,
        draggableWaypoints: true
    }).addTo(map);

    function updateMarkers() {
        // Met à jour les marqueurs pour qu'ils soient alignés avec les waypoints
        if (sourceMarker) {
            var sourceLatLng = control.getWaypoints()[0].latLng;
            sourceMarker.setLatLng(sourceLatLng);
        }
        if (destinationMarker) {
            var destinationLatLng = control.getWaypoints()[1].latLng;
            destinationMarker.setLatLng(destinationLatLng);
        }
    }

    // Initialisation de l'ajout de destination sur la carte
    initialiserAjoutDestination(map, control);
    initialiserSuppressionPoint(control);

    // Fonction pour afficher les suggestions
    function afficherSuggestions(input, containerSuggestions, inputElement) {
        if (input.length < 2) {
            containerSuggestions.innerHTML = '';
            return;
        }

        var url = `https://nominatim.openstreetmap.org/search?format=json&q=${encodeURIComponent(input)}&countrycodes=BF&accept-language=fr&addressdetails=1&limit=50`;

        fetch(url)
            .then(response => {
                if (!response.ok) {
                    throw new Error('Erreur réseau : ' + response.statusText);
                }
                return response.json();
            })
            .then(data => {
                console.log(data);
                containerSuggestions.innerHTML = '';
                if (data.length > 0) {
                    data.forEach(result => {
                        var suggestion = document.createElement('div');
                        suggestion.className = 'suggestion';
                        suggestion.textContent = result.display_name;
                        suggestion.onclick = function() {
                            inputElement.value = result.display_name;
                            var destinationLatLng = [result.lat, result.lon];

                            // Ajouter ou mettre à jour le marqueur
                            if (inputElement === document.getElementById('source-search')) {
                                if (sourceMarker) {
                                    map.removeLayer(sourceMarker);
                                }
                                sourceMarker = L.marker(destinationLatLng, { draggable: true })
                                    .addTo(map)
                                    .bindPopup("Point de départ")
                                    .openPopup()
                                    .on('dragend', function(e) {
                                        var newLatLng = e.target.getLatLng();
                                        control.spliceWaypoints(0, 1, newLatLng);
                                        updateMarkers(); // Met à jour les marqueurs sur la carte
                                    });
                            } else {
                                if (destinationMarker) {
                                    map.removeLayer(destinationMarker);
                                }
                                destinationMarker = L.marker(destinationLatLng, { draggable: true })
                                    .addTo(map)
                                    .bindPopup("Point d'arrivée")
                                    .openPopup()
                                    .on('dragend', function(e) {
                                        var newLatLng = e.target.getLatLng();
                                        control.spliceWaypoints(1, 1, newLatLng);
                                        updateMarkers(); // Met à jour les marqueurs sur la carte
                                    });
                            }
                            containerSuggestions.innerHTML = '';
                            // Déclenche automatiquement l'itinéraire après avoir sélectionné les points
                            definirItineraireAutomatique();
                        };
                        containerSuggestions.appendChild(suggestion);
                    });
                }
            })
            .catch(error => {
                console.error("Erreur lors de la récupération des suggestions : ", error);
            });
    }

    // Écouteurs pour les champs de recherche
    document.getElementById('source-search').addEventListener('input', function() {
        var input = this.value;
        var containerSuggestions = document.getElementById('source-suggestions');
        afficherSuggestions(input, containerSuggestions, this);
    });

    document.getElementById('destination-search').addEventListener('input', function() {
        var input = this.value;
        var containerSuggestions = document.getElementById('destination-suggestions');
        afficherSuggestions(input, containerSuggestions, this);
    });

    // Fonction pour définir automatiquement l'itinéraire sans bouton
    function definirItineraireAutomatique() {
        var sourceQuery = document.getElementById('source-search').value;
        var destinationQuery = document.getElementById('destination-search').value;

        if (sourceQuery && destinationQuery) {
            fetch(`https://nominatim.openstreetmap.org/search?format=json&q=${encodeURIComponent(sourceQuery)}&countrycodes=BF`)
                .then(response => response.json())
                .then(data => {
                    if (data.length > 0) {
                        var sourceLatLng = [data[0].lat, data[0].lon];
                        fetch(`https://nominatim.openstreetmap.org/search?format=json&q=${encodeURIComponent(destinationQuery)}&countrycodes=BF`)
                            .then(response => response.json())
                            .then(data => {
                                if (data.length > 0) {
                                    var destinationLatLng = [data[0].lat, data[0].lon];
                                    control.setWaypoints([sourceLatLng, destinationLatLng]);
                                    
                                    // Ajouter les marqueurs
                                    if (sourceMarker) {
                                        map.removeLayer(sourceMarker);
                                    }
                                    sourceMarker = L.marker(sourceLatLng, { draggable: true })
                                        .addTo(map)
                                        .bindPopup("Point de départ")
                                        .on('dragend', function(e) {
                                            var newLatLng = e.target.getLatLng();
                                            control.spliceWaypoints(0, 1, newLatLng);
                                            updateMarkers(); // Met à jour les marqueurs sur la carte
                                        });

                                    if (destinationMarker) {
                                        map.removeLayer(destinationMarker);
                                    }
                                    destinationMarker = L.marker(destinationLatLng, { draggable: true })
                                        .addTo(map)
                                        .bindPopup("Point d'arrivée")
                                        .on('dragend', function(e) {
                                            var newLatLng = e.target.getLatLng();
                                            control.spliceWaypoints(1, 1, newLatLng);
                                            updateMarkers(); // Met à jour les marqueurs sur la carte
                                        });

                                    map.setView(sourceLatLng, 9);
                                } else {
                                    alert("Destination d'arrivée non trouvée, veuillez entrer une destination correcte.");
                                }
                            });
                    } else {
                        alert("Destination de départ non trouvée, veuillez entrer une destination correcte.");
                    }
                });
        } else {
            alert('Veuillez entrer à la fois une destination de départ et une destination d\'arrivée.');
        }
    }
};
